"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const react_2 = require("@vscode/webview-ui-toolkit/react");
const react_use_1 = require("react-use");
const react_intl_1 = require("react-intl");
const PickableList_1 = __importDefault(require("../PickableList"));
const channel_1 = require("../../../common/data/channel");
const commit_1 = require("../../../../git/commit");
const useBatchCommits_1 = require("./useBatchCommits");
const useColumnResize_1 = require("./useColumnResize");
const constants_1 = require("./constants");
const index_module_scss_1 = __importDefault(require("./index.module.scss"));
const CommitsTableInner = ({ totalWidth, intl }) => {
    const headerRef = (0, react_1.useRef)(null);
    const scrollContainerRef = (0, react_1.useRef)(null);
    const progressBarRef = (0, react_1.useRef)(null);
    const lastScrollTopRef = (0, react_1.useRef)(0);
    const buffer = 50;
    const channel = (0, react_1.useContext)(channel_1.ChannelContext);
    const showProgressBar = (0, react_1.useCallback)(() => { var _a; return (_a = progressBarRef.current) === null || _a === void 0 ? void 0 : _a.classList.add(index_module_scss_1.default['active']); }, [progressBarRef]);
    const hideProgressBar = (0, react_1.useCallback)(() => { var _a; return (_a = progressBarRef.current) === null || _a === void 0 ? void 0 : _a.classList.remove(index_module_scss_1.default['active']); }, [progressBarRef]);
    const setDescription = (0, react_1.useCallback)((count) => channel.setDescription(() => { }, count), [channel]);
    const { commits, commitsCount, optionRef, setBatchedCommits, loadingRef, hasMoreCommitsRef } = (0, useBatchCommits_1.useBatchCommits)([headerRef, scrollContainerRef, progressBarRef], [hideProgressBar, setDescription]);
    function diff(sortedRefs, commits) {
        channel.viewChanges(sortedRefs);
        channel.viewDetails(commits);
    }
    const subscribeSwitcher = (0, react_1.useCallback)(() => {
        channel.subscribeSwitcher((batchedCommits) => setBatchedCommits(batchedCommits));
        channel.setShowProgressSubscriber(showProgressBar);
    }, [channel, setBatchedCommits, showProgressBar]);
    const onSelectReference = (0, react_1.useCallback)(() => channel.switchReference(), [channel]);
    const onFilter = (0, react_1.useCallback)((prop) => {
        switch (prop) {
            case "description":
                channel.filterMessage();
                break;
            case "author":
                channel.filterAuthor();
                break;
        }
    }, [channel]);
    const [locationIndex, setLocationIndex] = (0, react_1.useState)();
    const onLocate = (0, react_1.useCallback)((prop) => __awaiter(void 0, void 0, void 0, function* () {
        switch (prop) {
            case "hash": {
                const hash = yield channel.inputHash();
                if (!hash) {
                    return;
                }
                const index = commits.findIndex((commit) => commit.startsWith(hash || ""));
                if (index === -1) {
                    channel.showWarningMessage("No commit matched!");
                }
                setLocationIndex(index);
                // destroy location index after the blink animation finished
                setTimeout(() => {
                    setLocationIndex(undefined);
                }, 1500);
                break;
            }
            default:
                break;
        }
    }), [channel, commits]);
    const headers = (0, react_1.useMemo)(() => {
        return constants_1.HEADERS;
    }, []);
    const { columns } = (0, useColumnResize_1.useColumnResize)(headers, totalWidth);
    (0, react_1.useEffect)(() => {
        subscribeSwitcher();
        channel.autoRefreshLog();
    }, [channel, subscribeSwitcher]);
    (0, react_1.useEffect)(() => {
        const container = scrollContainerRef.current;
        if (!container) {
            return;
        }
        const onScroll = () => {
            headerRef.current.scrollLeft = container.scrollLeft;
            const isScrollingDown = container.scrollTop > lastScrollTopRef.current;
            const isScrollToBottom = container.scrollHeight - container.scrollTop - buffer <= container.clientHeight;
            lastScrollTopRef.current = container.scrollTop;
            if (isScrollingDown && isScrollToBottom && !loadingRef.current && hasMoreCommitsRef.current) {
                loadingRef.current = true;
                channel.loadMoreCommits(setBatchedCommits, optionRef.current);
            }
        };
        container.addEventListener("scroll", onScroll);
        return () => {
            container.removeEventListener("scroll", onScroll);
        };
    });
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsxs)("div", Object.assign({ className: index_module_scss_1.default["commit-headers"], ref: headerRef }, { children: [columns.map(({ prop, label, filterable, locatable, filterLogOption, hasDivider, size, dragBind, minWidth }, index) => {
                        var _a;
                        return ((0, jsx_runtime_1.jsxs)(react_1.Fragment, { children: [hasDivider && ((0, jsx_runtime_1.jsx)("div", Object.assign({}, dragBind(index), { className: index_module_scss_1.default.divider }))), (0, jsx_runtime_1.jsx)("div", Object.assign({ className: index_module_scss_1.default["header-item"], style: {
                                        width: `${size}px`,
                                        minWidth: `${minWidth}px`
                                    } }, { children: prop === "graph" ? ((0, jsx_runtime_1.jsxs)(react_2.VSCodeButton, Object.assign({ className: index_module_scss_1.default["ref-button"], "data-button": true, appearance: "icon", title: `${intl.formatMessage({ id: 'reference.select.branchOrReference' })} · ${optionRef.current.ref || intl.formatMessage({ id: 'reference.all' })}`, "aria-label": "All", onClick: () => onSelectReference() }, { children: [(0, jsx_runtime_1.jsx)("span", { className: "codicon codicon-git-branch" }), (0, jsx_runtime_1.jsx)("span", Object.assign({ className: index_module_scss_1.default.text }, { children: optionRef.current.ref || intl.formatMessage({ id: 'reference.all' }) }))] }))) : ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("span", { children: intl.formatMessage({ id: label }) }), filterable && ((0, jsx_runtime_1.jsx)(react_2.VSCodeButton, Object.assign({ appearance: "icon", onClick: () => onFilter(prop) }, { children: (0, jsx_runtime_1.jsx)("span", { className: `codicon codicon-filter${((_a = optionRef.current[filterLogOption]) === null || _a === void 0 ? void 0 : _a.length)
                                                        ? "-filled"
                                                        : ""}` }) }))), locatable && ((0, jsx_runtime_1.jsx)(react_2.VSCodeButton, Object.assign({ appearance: "icon", onClick: () => onLocate(prop) }, { children: (0, jsx_runtime_1.jsx)("span", { className: "codicon codicon-search" }) })))] })) }))] }, prop));
                    }), (0, jsx_runtime_1.jsx)("div", Object.assign({ ref: progressBarRef, className: `${index_module_scss_1.default["progress-container"]} ${index_module_scss_1.default['infinite']}` }, { children: (0, jsx_runtime_1.jsx)("div", { className: index_module_scss_1.default["progress-bar"] }) }))] })), (0, jsx_runtime_1.jsx)("div", Object.assign({ className: index_module_scss_1.default["commits-area"] }, { children: (0, jsx_runtime_1.jsx)(PickableList_1.default, { list: commits, keyLength: 40, locationIndex: locationIndex, itemPipe: commit_1.parseCommit, itemRender: (commit) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ className: index_module_scss_1.default.commit }, { children: columns.map(({ prop, size, minWidth, transformer }) => ((0, jsx_runtime_1.jsx)("span", Object.assign({ style: {
                                width: `${size}px`,
                                minWidth: `${minWidth}px`,
                            }, "data-prop": prop }, { children: transformer(commit, intl) }), prop))) }))), size: commitsCount, onPick: (ids, commits) => diff(ids, commits), ref: scrollContainerRef }) }))] }));
};
const CommitsTable = (props) => {
    const [ref, { width }] = (0, react_use_1.useMeasure)();
    return ((0, jsx_runtime_1.jsx)("div", Object.assign({ ref: ref, className: index_module_scss_1.default.container }, { children: (0, jsx_runtime_1.jsx)(CommitsTableInner, { totalWidth: width, intl: props.intl }) })));
};
exports.default = (0, react_intl_1.injectIntl)(CommitsTable);
//# sourceMappingURL=index.js.map